# Example Animation Pack

A minimal starter template for Papyrus Visual Packs.

## Files

- `manifest.json` — Pack metadata and cue definitions
- `index.html` — Entry point with animation logic
- `snapshot.svg` — Static fallback for print mode
- `README.md` — This file (not required in packs)

## Cues

This pack responds to three cues:

| Cue     | Effect                              |
|---------|-------------------------------------|
| `start` | Starts the pulsing animation        |
| `pause` | Pauses and dims the animation       |
| `reset` | Stops animation, returns to initial |

## Usage in MDX

```mdx
<Visual id="example-animation" height={400} />
<Cue target="example-animation" when="visible" name="start" />
```

## Creating Your Own

1. Copy this folder as a starting point
2. Replace the animation in `index.html`
3. Update `manifest.json` with your pack name and cues
4. Create a new `snapshot.svg` for print mode
5. ZIP everything and upload via the Papyrus admin dashboard
